#!/bin/sh

set -xe

export PATH=/bin:/sbin:/usr/bin

# Mount base susbsystems
mkdir /proc /sys /run
mount proc /proc -t proc
mount sysfs /sys -t sysfs
mount devtmpfs /dev -t devtmpfs
[ -d /dev/pts ] || mkdir /dev/pts
mount devpts /dev/pts -t devpts
mount tmpfs /run -t tmpfs

INIT=/sbin/init

rootfs=/dev/vda
rootmnt=/newroot
modules_dev=/dev/vdb
rwdelta=/dev/vdc
overlay_root=y
kernelrelease=$(uname -r)

for arg in `cat /proc/cmdline`; do
    case "$arg" in
	init=*)
	    INIT="${arg#init=}"
	    ;;
	root=*)
	    rootfs="${arg#root=}"
	    ;;
	modules_dev=*)
	    modules_dev="${arg#modules_dev=}"
	    ;;
	rwdelta=*)
	    rwdelta="${arg#rwdelta=}"
	    ;;
	no_overlay_root)
	    overlay_root=""
	    ;;
	esac
done
[ -z "$rootfs" ] && exit 1

# load base filesystem modules directly from initrd image 
sh /init_base_modules.sh

# Setup overlay root
to_umount=""

mkdir /ovl_rootfs
mount $rootfs  /ovl_rootfs -oro
lowers="/ovl_rootfs"


if [ "$modules_dev" != "" ]
then
    mkdir /ovl_modules

    if [ "${modules_dev:0:3}" == "9p:" ]
    then
	mount -t 9p ${modules_dev:3} /ovl_modules -oro,trans=virtio
    else
	mount $modules_dev /ovl_modules -oro
    fi
    lowers="$lowers:/ovl_modules"

    # Mound modules dev to conventional place so modprobe can find it
    mount /ovl_modules/lib/modules /lib/modules -obind
    to_umount="$to_umount /lib/modules"
fi


mkdir ${rootmnt}
if  [ "$overlay_root" == "y" ]
then
    # Setup overlay root mount
    mkdir /media_rw
    mount $rwdelta /media_rw
    mkdir -p /media_rw/up
    mkdir -p /media_rw/work
    mount -t overlay -o lowerdir=$lowers,upperdir=/media_rw/up,workdir=media_rw/work root ${rootmnt}
else
    mount --move /ovl_rootfs ${rootmnt}
fi


# Run custom  scripts
for i in $(find /scripts/ -name '*.sh')
do
    echo "run $i"
    sh $i
done

# Switch to ${rootmnt}
mount --move /proc ${rootmnt}/proc
mount --move /sys ${rootmnt}/sys
mount --move /dev ${rootmnt}/dev
mount --move /run ${rootmnt}/run

# Umount tmp mounts
test -z "$to_umount" || umount $to_umount

exec switch_root ${rootmnt} "$INIT" "$@"
