IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:kernel)

SET(LZ4_VERSION v1.9.2)
SET(LZ4_RESOURCE 1682710717)
SET(LZ4_SRC lz4-${LZ4_VERSION}.tar.xz)
SET(LZ4_OUT lz4-static.tar.gz)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${VMEXEC_DEF_ROOTFS}
)

FROM_SANDBOX(
    FILE ${LZ4_RESOURCE}
    OUT ${LZ4_SRC}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} --vcpu 8 --mem 8G  --
                   /usr/bin/python3 build-lz4.py build --install-deps ${LZ4_SRC} ${LZ4_OUT}
    CWD ${BINDIR}
    IN build-lz4.py
       ${LZ4_SRC}
       ${QEMU_BIN_APP}
       ${VMEXEC_DEF_ROOTFS}/rootfs.img

    OUT_NOAUTO ${LZ4_OUT}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
#endif
