IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:kernel)

SET(VERSION 5.15-2231-ga94bafdad3e8)
SET(SRC_RESOURCE 2566538826)
SET(SRC_TARBALL linux-v${VERSION}.tar.gz)
SET(OUT_TARBALL perf-static.tar.gz)

SET(ELFUTILS_VERSION 0.178)
SET(ELFUTILS_RESOURCE 1310084221)
SET(ELFUTILS_TARBALL elfutils-${ELFUTILS_VERSION}.tar.bz2)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${VMEXEC_DEF_ROOTFS}
)

FROM_SANDBOX(
    FILE ${SRC_RESOURCE}
    OUT ${SRC_TARBALL}
)

FROM_SANDBOX(
    FILE ${ELFUTILS_RESOURCE}
    OUT ${ELFUTILS_TARBALL}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} --vcpu 8 --mem 8G  --
                   build.py build --install-deps --elfutils ${ELFUTILS_TARBALL} ${SRC_TARBALL} ${OUT_TARBALL}
    CWD ${BINDIR}
    IN build.py
       ${SRC_TARBALL}
       ${ELFUTILS_TARBALL}
       ${QEMU_BIN_APP}
       ${VMEXEC_DEF_ROOTFS}/rootfs.img

    OUT_NOAUTO ${OUT_TARBALL}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
