IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:kernel)

SET(VERSION V0.11.18)
SET(SRC_RESOURCE 1679783199)
SET(SRC_TARBALL stress-ng-${VERSION}.tar.xz)
SET(OUT_TARBALL stress-ng-static.tar.gz)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${VMEXEC_DEF_ROOTFS}
)

FROM_SANDBOX(
    FILE ${SRC_RESOURCE}
    OUT ${SRC_TARBALL}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} --vcpu 8 --mem 8G  --
                   build.py build --install-deps ${SRC_TARBALL} ${OUT_TARBALL}
    CWD ${BINDIR}
    IN build.py
       ${SRC_TARBALL}
       ${QEMU_BIN_APP}
       ${VMEXEC_DEF_ROOTFS}/rootfs.img

    OUT_NOAUTO ${OUT_TARBALL}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
#endif
