import os

try:
    from setuptools import setup, find_packages
    from pkg_resources import require
except ImportError:
    import sys
    print >> sys.stderr, 'Please install distribute from PyPi first.'
    exit(1)

from setuptools.command.bdist_egg import bdist_egg, walk_egg, log
from setuptools.command.test import test

NS_PKG_STUB = '__import__("pkg_resources").declare_namespace(__name__)'


class PyTest(test):
    user_options = [
        ('keywords=', 'k', 'Pass keywords to pytest.'),
        ('exitfirst', 'x', 'Exit after first failure.'),
        ('showout', 's', 'Dont hide tests stdout/stderr.'),
        ('quiet', 'q', 'Be quiet.'),
    ]

    def initialize_options(self):
        self.keywords = None
        self.exitfirst = False
        self.showout = False

    def finalize_options(self):
        if self.exitfirst:
            self.exitfirst = True

    def run(self):
        self.run_tests()

    def run_tests(self):
        import pytest
        import sys

        if 'test' in sys.argv:
            args = sys.argv[sys.argv.index('test') + 1:]
        else:
            args = sys.argv[1:]

        raise SystemExit(pytest.main(args=args))


setup(
    name='skynet-keychain-service',
    version='1.0',
    description='keychain service.',
    zip_safe=True,
    install_requires=[
        'gevent',
        'requests',
        'Pyro4==4.8',
    ],
    packages=['skynet_keychain'],
    package_dir={'skynet_keychain': 'src'},
    entry_points={
        'console_scripts': [
            'keychain = skynet_keychain.server:main',
            'keychain-control = skynet_keychain.server:control',
        ],
    },
    cmdclass={'test': PyTest}
)
