package main

import (
	"a.yandex-team.ru/infra/kube-auth-webhook/pkg/server"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmauth"
	"crypto/tls"
	"fmt"
	"net"
	"net/http"
	"os"
	"strconv"
)

func main() {
	if len(os.Args) < 4 {
		fmt.Println("cmdline should be: 'kube-ath-webhook <path-to-key> <path-to-cert> <ip-addr>'")
		os.Exit(1)
		return
	}
	l, err := zap.New(zap.ConsoleConfig(log.InfoLevel))
	if err != nil {
		fmt.Printf("Error: %s\n", err)
		os.Exit(1)
	}
	die := func(err error) {
		l.Errorf("Error: %s", err)
		os.Exit(1)
	}
	ipaddr := os.Args[3]
	bb, err := initBB()
	if err != nil {
		die(err)
	}
	api, err := server.New(l, bb, ipaddr)
	if err != nil {
		die(err)
	}
	http.HandleFunc("*", api.AuthHandler)
	s := http.Server{
		Handler: http.HandlerFunc(api.AuthHandler),
		TLSConfig: &tls.Config{
			// TODO: remove this hack and use right certs with api-server
			VerifyConnection: nil,
		},
	}
	ln, err := net.Listen("tcp", ":9999")
	if err != nil {
		die(err)
	}
	defer ln.Close()
	l.Infof("Listening on port 9999 for requests...")
	certFilename := os.Args[2]
	keyFilename := os.Args[1]
	l.Infof("Starting with key: '%s' cert: '%s'\n", keyFilename, certFilename)
	if err := s.ServeTLS(ln, certFilename, keyFilename); err != nil {
		die(err)
	}
}

func initBB() (blackbox.Client, error) {
	z, _ := zap.New(zap.ConsoleConfig(log.InfoLevel))
	var tvmc tvm.Client
	if envTvmID, ok := os.LookupEnv("TVM_ID"); ok {
		tvmIntID, err := strconv.Atoi(envTvmID)
		if err != nil {
			return nil, err
		}
		token, ok := os.LookupEnv("TVM_AUTH_TOKEN")
		if !ok {
			return nil, fmt.Errorf("TVM_ID env var given but can not get token from 'TVM_AUTH_TOKEN' env var")
		}
		settings := tvmauth.TvmAPISettings{
			SelfID: tvm.ClientID(tvmIntID),
			ServiceTicketOptions: tvmauth.NewAliasesOptions(
				token,
				map[string]tvm.ClientID{
					"bb": httpbb.IntranetEnvironment.TvmID,
				},
			),
		}
		tvmc, err = tvmauth.NewAPIClient(settings, z)
		if err != nil {
			return nil, err
		}
	}
	return httpbb.NewIntranet(
		httpbb.WithLogger(z),
		httpbb.WithTVM(tvmc),
	)
}
