package auth

import (
	"a.yandex-team.ru/infra/kube-auth-webhook/pkg/kubeconfig"
	"a.yandex-team.ru/infra/kube-auth-webhook/pkg/oauth"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"context"
	"github.com/spf13/cobra"
	"time"
)

func Auth() *cobra.Command {
	return &cobra.Command{
		Use:   "auth",
		Short: "Get yandex auth token from",
		Args:  cobra.NoArgs,
		RunE: func(cmd *cobra.Command, args []string) error {
			l, err := zap.New(zap.ConsoleConfig(log.InfoLevel))
			if err != nil {
				return err
			}
			ctx, cancel := context.WithTimeout(context.Background(), 20*time.Second)
			defer cancel()
			token, err := oauth.GetTokenBySSH(ctx, l)
			if err != nil {
				return err
			}
			l.Infof("Received token from blackbox: %s", token)
			if err := kubeconfig.SaveYandexToken(token); err != nil {
				return err
			}
			l.Infof("Saved token in ~/.kube/authtoken")
			return nil
		},
	}
}
