package cert

import (
	"a.yandex-team.ru/infra/kube-auth-webhook/pkg/kubeconfig"
	"a.yandex-team.ru/infra/kube-auth-webhook/pkg/oauth"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"context"
	"github.com/spf13/cobra"
	"time"
)

func Cert() *cobra.Command {
	return &cobra.Command{
		Use:   "ca",
		Short: "Get yandex kube-apiserver RTC CA from yav",
		Args:  cobra.NoArgs,
		RunE: func(cmd *cobra.Command, args []string) error {
			l, err := zap.New(zap.ConsoleConfig(log.InfoLevel))
			if err != nil {
				return err
			}
			l.Infof("Loading Yandex token for yav authentication...")
			token, err := kubeconfig.LoadYandexToken()
			if err != nil {
				return err
			}
			l.Infof("Loaded '%s'", token)
			ctx, cancel := context.WithTimeout(context.Background(), 20*time.Second)
			defer cancel()
			l.Infof("Getting Yandex yandex kube-apiserver RTC CA from yav...")
			ca, err := oauth.GetKubeCACert(ctx, token)
			if err != nil {
				return err
			}
			l.Infof("Received:\n%s", ca)
			l.Infof("Saving CA in '~/.kube/ca.pem'...")
			if err := kubeconfig.SaveCACert(ca); err != nil {
				return err
			}
			l.Infof("Saved")
			return nil
		},
	}
}
