package config

import (
	"fmt"
	"github.com/spf13/cobra"
)

func Config() *cobra.Command {
	return &cobra.Command{
		Use:   "config",
		Short: "Setup kubeconfig for Yandex kube-apiserver RTC",
		Args:  cobra.NoArgs,
		RunE: func(cmd *cobra.Command, args []string) error {
			yellow := "\033[33m"
			reset := "\033[0m"
			fmt.Println("Setup yandex kube-apiserver RTC config")
			fmt.Println("Before run you need:\n" +
				"* oauth token in ~/.kube/authtoken (kubectl yandex auth)\n" +
				"* CA in ~/.kube/ca.pem (kubectl yandex ca)")
			scr := fmt.Sprintf("%s%s%s", yellow, script, reset)
			fmt.Printf("\nExec following for setup kubeconfig:\n%s\n", scr)
			return nil
		},
	}
}

// todo: disabled: need "k8s.io/kops/pkg/kubeconfig" contrib
//func updateConfig(l log.Logger) error {
//	addr := os.Getenv("KUBERNETES_MASTER")
//	if addr == "" {
//		return fmt.Errorf("can not get apiserver address from 'KUBERNETES_MASTER' env var")
//	}
//	token, err := kubeconfig.LoadYandexToken()
//	if err != nil {
//		return err
//	}
//	b := kubeconfig.NewBuilder("yandex-kubernetes-test")
//	ca, err := kubeconfig.ReedCA()
//	if err != nil {
//		return err
//	}
//	b.MakeUser(ca, token)
//	b.MakeCluster(addr)
//	if err := b.Write(); err != nil {
//		return err
//	}
//	l.Infof("Updated kubeconfig")
//	return nil
//}

const script = `KUBERNETES_PUBLIC_ADDRESS='hmhxgltylq4lxh5a.sas.yp-c.yandex.net'

kubectl config set-cluster yandex-apiserver \
--certificate-authority=~/.kube/ca.pem \
--embed-certs=true \
--server=https://${KUBERNETES_PUBLIC_ADDRESS}:6443

kubectl config set-credentials $(whoami) \
--token $(cat ~/.kube/authtoken)

kubectl config set-context yandex-apiserver-$(whoami) \
--cluster=yandex-apiserver \
--user=$(whoami)

kubectl config use-context yandex-apiserver-$(whoami)
`
