package main

import (
	"a.yandex-team.ru/infra/kube-auth-webhook/kubectl-yandex/auth"
	"a.yandex-team.ru/infra/kube-auth-webhook/kubectl-yandex/cert"
	"a.yandex-team.ru/infra/kube-auth-webhook/kubectl-yandex/config"
	"fmt"
	"github.com/spf13/cobra"
	"os"
)

func main() {
	rootCmd := &cobra.Command{
		Use:  "kubectl yandex",
		Long: "Yandex plugin for kubectl. Extend kubectl with auth/config gen helpers.",
	}
	Register(rootCmd)
	err := rootCmd.Execute()
	if err != nil {
		die(err)
	}
}

func Register(cmd *cobra.Command) {
	cmd.AddCommand(auth.Auth())
	cmd.AddCommand(cert.Cert())
	cmd.AddCommand(config.Config())
}

func die(err error) {
	fmt.Printf("Error: %s\n", err)
	os.Exit(1)
}
