package kubeconfig

import (
	"io"
	"os"
	"path"
)

const tokenPath = ".kube/authtoken"

func SaveYandexToken(token string) error {
	fname := path.Join(os.Getenv("HOME"), tokenPath)
	return os.WriteFile(fname, []byte(token), 0644)
}

func LoadYandexToken() (string, error) {
	f, err := os.Open(path.Join(os.Getenv("HOME"), tokenPath))
	if err != nil {
		return "", err
	}
	defer func() { _ = f.Close() }()
	token, err := io.ReadAll(f)
	if err != nil {
		return "", err
	}
	return string(token), nil
}
