package kubeconfig

import (
	"encoding/base64"
	"io"
	"k8s.io/kops/pkg/kubeconfig"
	"os"
	"path"
)

func ReedCA() ([]byte, error) {
	f, err := os.Open(path.Join(os.Getenv("HOME"), caPath))
	if err != nil {
		return nil, err
	}
	defer func() { _ = f.Close() }()
	ca, err := io.ReadAll(f)
	if err != nil {
		return nil, err
	}
	encoded := make([]byte, 0)
	base64.StdEncoding.Encode(encoded, ca)
	return encoded, nil
}

func NewBuilder(context string) *Builder {
	conf := kubeconfig.NewKubeconfigBuilder()
	conf.Context = context
	return &Builder{config: conf}
}

type Builder struct {
	config *kubeconfig.KubeconfigBuilder
}

func (b *Builder) MakeUser(caCert []byte, token string) {
	b.config.KubeBearerToken = token
	b.config.CACert = caCert
}

func (b *Builder) MakeCluster(addr string) {
	b.config.Server = addr
}

func (b *Builder) Write() error {
	return b.config.WriteKubecfg()
}
