package oauth

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/oauth"
	"a.yandex-team.ru/library/go/yandex/yav/httpyav"
	"context"
	"encoding/base64"
	"fmt"
)

const (
	ClientID     = "ff9180ea81db4f60aa3b11971b584490"
	ClientSecret = "91f186202867434c944ea39c8a051176"

	// https://yav.yandex-team.ru/secret/sec-01f7thy1m6pap843n5vqjcw57j/explore/versions
	latestKubeApiserverRTCVersion = "ver-01f7tw76jxm6wv7zzc7hm5a7f2"
)

func GetTokenBySSH(ctx context.Context, l log.Logger) (string, error) {
	l.Infof("Try to exchange ssh key to OAuth token for '%s'\n", ClientID)
	return oauth.GetTokenBySSH(ctx, ClientID, ClientSecret, oauth.WithLogger(l.Structured()))
}

func GetKubeCACert(ctx context.Context, token string) ([]byte, error) {
	c, err := httpyav.NewClient(httpyav.WithOAuthToken(token))
	if err != nil {
		return nil, nil
	}
	ver, err := c.GetVersion(ctx, latestKubeApiserverRTCVersion)
	if err != nil {
		return nil, err
	}
	ca, found := "", false
	for _, v := range ver.Version.Values {
		if v.Key == "CA" {
			ca = v.Value
			found = true
		}
	}
	if !found {
		return nil, fmt.Errorf("secret value with CA was not found in '%s' version", latestKubeApiserverRTCVersion)
	}
	return base64.StdEncoding.DecodeString(ca)
}
