#!/bin/bash

/opt/kube-apiserver/cfssl gencert -initca ca-csr.json | /opt/kube-apiserver/cfssljson -bare ca

/opt/kube-apiserver/cfssl gencert \
  -ca=ca.pem \
  -ca-key=ca-key.pem \
  -config=ca-config.json \
  -profile=kubernetes \
  admin-csr.json | /opt/kube-apiserver/cfssljson -bare admin

KUBERNETES_PUBLIC_ADDRESS=$(hostname)
KUBERNETES_HOSTNAMES=kubernetes,kubernetes.default,kubernetes.default.svc,kubernetes.default.svc.cluster,kubernetes.svc.cluster.local

/opt/kube-apiserver/cfssl gencert \
  -ca=ca.pem \
  -ca-key=ca-key.pem \
  -config=ca-config.json \
  -hostname=10.32.0.1,10.240.0.10,10.240.0.11,10.240.0.12,${KUBERNETES_PUBLIC_ADDRESS},127.0.0.1,${KUBERNETES_HOSTNAMES} \
  -profile=kubernetes \
  kubernetes-csr.json | /opt/kube-apiserver/cfssljson -bare kubernetes

/opt/kube-apiserver/cfssl gencert \
  -ca=ca.pem \
  -ca-key=ca-key.pem \
  -config=ca-config.json \
  -profile=kubernetes \
  service-account-csr.json | /opt/kube-apiserver/cfssljson -bare service-account

/opt/kube-apiserver/cfssl gencert \
  -ca=ca.pem \
  -ca-key=ca-key.pem \
  -config=ca-config.json \
  -profile=kubernetes \
  webhook.json | /opt/kube-apiserver/cfssljson -bare webhook

# Generate certificates for kubelet workers
for instance in local-kubelet; do
cat > ${instance}-csr.json <<EOF
{
  "CN": "system:node:${instance}",
  "key": {
    "algo": "rsa",
    "size": 2048
  },
  "names": [
    {
      "C": "RU",
      "L": "",
      "O": "system:nodes",
      "OU": "Yandex Kubernetes kubelet ${instance}",
      "ST": ""
    }
  ]
}
EOF
/opt/kube-apiserver/cfssl gencert \
  -ca=ca.pem \
  -ca-key=ca-key.pem \
  -config=ca-config.json \
  -hostname=${instance},$(hostname),localhost \
  -profile=kubernetes \
  ${instance}-csr.json | /opt/kube-apiserver/cfssljson -bare ${instance}
done
