package ypsync

import (
	"a.yandex-team.ru/yp/go/yp"
	"fmt"
)

type ClientFactory struct{}

func NewClientFactory() *ClientFactory {
	return &ClientFactory{}
}

func (zf *ClientFactory) For(zone string) (*yp.Client, error) {
	geo, ok := zoneMap[zone]
	if !ok {
		return nil, fmt.Errorf("failed to find YP cluster for zone='%s'", zone)
	}
	// We need YP client configured (uses token from YP_TOKEN or ~/.yp/token)
	return yp.NewClient(geo, yp.WithSystemAuthToken())
}
