package ypsync

import (
	"context"
	"k8s.io/apimachinery/pkg/types"
)

// Interface to synchronize endpoints
type Interface interface {
	Expose(ctx context.Context, set map[string]*Set) error
	Delete(ctx context.Context, name types.NamespacedName) error
}

// Factory is an YPSync client returning zone connections
type Factory interface {
	For(zone string) (Interface, error)
}
