This helm chart will create EKS cluster.

You must run this chart after `core` chart.
----

You must use keyId of the KMS Key, that was generated by `core` helm chart.
To get it, you can use the script below. Use the same values of variables, that you used in core/values.yaml.

```
export NAMESPACE=<namespace>
export PROJECT_NAME=<pn>
export PROJECT_SUFFIX=<ps>

kubectl get keys -n ${NAMESPACE} -o jsonpath="{.status.atProvider.keyId}" \
   eks-cluster-key-${PROJECT_NAME}-<PROJECT_SUFFIX>; echo
```

----

You must use IPv6 CIDR, that was generated by `core` helm chart.

To get generated IPv6 CIDR you can run:
```
export NAMESPACE=<namespace>
export PROJECT_NAME=<pn>
export PROJECT_SUFFIX=<ps>

aws ec2 describe-vpcs --vpc-ids \
  $(kubectl get vpcs -n ${NAMESPACE} vpc-${PROJECT_NAME}-${PROJECT_SUFFIX} -o jsonpath="{.status.atProvider.id}") \
  | jq .Vpcs[0].Ipv6CidrBlockAssociationSet[0].Ipv6CidrBlock

```
