#!/bin/bash
# https://github.com/terraform-providers/terraform-provider-aws/issues/10104
set -eo pipefail

if [ -z $1 ]; then
    echo "Usage: ./oidc_thumbprint.sh <aws-region>"
    exit
fi

AWS_REGION="$1"
AWS_HOST="oidc.eks.${AWS_REGION}.amazonaws.com"


echo | openssl s_client -servername "${AWS_HOST}" -showcerts -connect "${AWS_HOST}:443" 2>&- \
  | sed -n '/-----BEGIN CERTIFICATE-----/h;//!H;$!d;x;s/\(.*-----END CERTIFICATE-----\).*/\1/p' \
  | openssl x509 -fingerprint -sha1 -noout \
  | tr '[:upper:]' '[:lower:]' \
  | sed 's/://g; s/.*=\(.*\)/\1/'
