#!/bin/bash

set -o xtrace
set -e

HELM_EXPERIMENTAL_OCI=1
SERVICE=s3
ACK_K8S_NAMESPACE=ack-system
AWS_REGION=us-west-2
AWS_ACCOUNT_ID=$(aws sts get-caller-identity --query Account --output text)

for SERVICE in ec2
do
    RELEASE_VERSION=$(curl -sL https://api.github.com/repos/aws-controllers-k8s/$SERVICE-controller/releases/latest | jq -r '.tag_name')
    #RELEASE_VERSION=v0.0.4
    CHART_REF=$SERVICE-chart
    CHART_REPO=public.ecr.aws/aws-controllers-k8s/$CHART_REF
    CHART_PACKAGE=$CHART_REF-$RELEASE_VERSION.tgz

    CHART_EXPORT_PATH=/tmp/chart/$SERVICE
    mkdir -p $CHART_EXPORT_PATH

    helm pull oci://$CHART_REPO --version latest -d $CHART_EXPORT_PATH
    tar xvf $CHART_EXPORT_PATH/$CHART_PACKAGE -C $CHART_EXPORT_PATH

    helm install --create-namespace --namespace $ACK_K8S_NAMESPACE ack-$SERVICE-controller \
        --set aws.account_id="$AWS_ACCOUNT_ID" \
        --set aws.region="$AWS_REGION" \
        $CHART_EXPORT_PATH/$SERVICE-chart

done
