#!/bin/bash

set -e

if [ "$#" -ne 4 ]; then
    echo 'Invalid arguments count.'
    echo
    echo 'Use: "get-client-config.sh <azure-access-token> <azure-resource-group> <azure-aks-name> <subscription-id>"'
    exit 2
fi

# Set auth info here
AZURE_ACCESS_TOKEN=$1
AZURE_AUTH_HEADER="Authorization: Bearer $AZURE_ACCESS_TOKEN"

AZURE_SUBSCRIPTION_ID=$4

AZURE_RESOURCE_GROUP=$2
AZURE_AKS_NAME=$3

echo "Getting AKS credentials"

CLUSTER_CREDENTIALS=$(
    curl -s --request POST \
    --data '' \
    --header "Content-Type: application/json" \
    --header "$AZURE_AUTH_HEADER" \
    "https://management.azure.com/subscriptions/$AZURE_SUBSCRIPTION_ID/resourceGroups/$AZURE_RESOURCE_GROUP/providers/Microsoft.ContainerService/managedClusters/$AZURE_AKS_NAME/listClusterUserCredential?api-version=2021-05-01"
  )

AKS_KUBECONFIG=$(echo "$CLUSTER_CREDENTIALS" | jq -r '.kubeconfigs[0].value' | base64 -d)

echo "AKS kubeconfig:"

echo "---"
echo "$AKS_KUBECONFIG"
echo "---"

echo "Merging AKS kubeconfig in ~/.kube/config"

echo "$AKS_KUBECONFIG" > ~/.kube/akskubeconfig
# rename context to 'rtc'
if [ "$AZURE_AKS_NAME" != "aks" ]; then
    kubectl --kubeconfig ~/.kube/akskubeconfig config rename-context "$AZURE_AKS_NAME" aks
fi
KUBECONFIG=~/.kube/akskubeconfig:~/.kube/config kubectl config view --merge --flatten > ~/.kube/tmpconfig
mv ~/.kube/tmpconfig ~/.kube/config
rm ~/.kube/akskubeconfig

echo "AKS kubeconfig merged in ~/.kube/config as 'aks' context"
