#!/bin/bash

if [ "$#" -ne 1 ]; then
    echo 'Invalid arguments count. You should specify namespace.'
    echo
    echo 'Use: "configure-provider.sh <namespace>"'
    exit 2
fi

# create k8s secret with creds
kubectl create secret generic azure-creds -n "$1" --from-file=creds=./creds.json

SPEC=$(cat <<-END
apiVersion: azure.crossplane.io/v1beta1
kind: ProviderConfig
metadata:
  name: default
  namespace: $1
spec:
  credentials:
    source: Secret
    secretRef:
      namespace: $1
      name: azure-creds
      key: creds
END
)

echo "$SPEC" > "$1.yaml" && \
kubectl apply -f "$1.yaml"
