# Управление ролями в Azure через IDM

Общий подход к управлению ролями в облаках через IDM:

1) Есть IDM система Cloud Crossplane (https://idm.yandex-team.ru/system/cloud-crossplane),
   которая позволяет управлять пользователями в группах on-prem AD (Active Directory).
   При запросе роли в этой системе необходимо указать тип стенда (sandbox, dev, prod и тп),
   а также одну из предложенных ролей (owner, contributor, devops, developer, viewer).
   Апрув запрошенной роли в этой системе есть добавление пользователя в указанную в workflow AD группу.

2) Есть on-prem AD, которая синхронизирована с Azure AD (синхронизируется каждые 30минут),
   те если в on-prem AD в AD группу добавить пользователя, то после синхронизации
   этот пользователь будет добавлен в синхронизированную группу в Azure AD.

3) Azure позволяет Azure AD группам назначать свои роли на свои ресурсы (назначается вручную в Azure).
   Доступ к определенному ресурсу Azure обеспечивается путем включения пользователя в AD группу, у которой
   выданы роли на требуемый ресурс.
   Одним из ресурсов может являться подписка Azure (аналог облака), но так делать не рекомендуется из соображений безопасности.


Таким образом, единожды выдав каждой из Azure AD групп определенный набор Azure ролей на определенные ресурсы в Azure, можно,
выдавая или отзывая роли в IDM системе Cloud Crossplane, управлять доступами к фиксированного набору ресурсам в Azure.

# Настройка процесса

Для настройки процесса потребовалось:

1) Создать IDM систему Cloud Crossplane

Созданием IDM системы занимается команда IDM (Служба разработки ABC и IDM). Система создается один раз. Планируется, что
интеграции через AD с другими облаками будут делаться в этой же системе - варианты развития этой системы на рассмотрении у команды IDM.

2) Создать AD группы

Создать AD группу можно самостоятельно. Не рекомендуется создавать AD группы через запросы в ServiceDesk - время потратите, результат не получите.
Создать AD-группу и связать ее с IDM-системой нужно через IDM-систему "AD" (здесь AD это название системы): запросить роль -> AD/global/связь системы с группой,
в качестве владельца роли нужно указать robot-idm-ad-system@.

В появившихся полях заполняем:

- слаг системы: cloud-crossplane
- DN(distinguished name) группы: например, CN=az-crossplane-sandbox-developer,OU=IDM,OU=Projects,OU=Groups,DC=ld,DC=yandex,DC=ru
  CN - уникальное и читаемое имя AD-группы.

После апрувов (если они требуются) в on-prem AD будет создана AD группа. За счет синка между on-prem AD и Azure AD (он работает для всех AD групп)
новая группа появится в Azure AD.

3) В workflow IDM системы необходимо для каждого типа стенда и каждой роли указать DN AD группы
   (редактировать workflow может только ответственный за IDM систему).

Необходимо учитывать, что DN в workflow надо указывать дважды - в персональном workflow и в групповом workflow.
После сохранения изменений можно запрашивать роли на стендах.

*Важно!*: сейчас для экспериментов можно выбирать только стенд sandbox.

4) Создать подписку в Azure.

   Регистрироваться в Azure необязательно (при регистрации дается 200$ на месяц на эксперименты с Azure).
   Нужно логиниться по SSO.

   Для работы корпоративным аккаунтом необходимо:
    - получить доступ в организацию в Azure
    - подключить свой корпоративный аккаунт к корпоративному billing аккаунту


Для всего этого необходимо завести тикет в очереди PLN (например https://st.yandex-team.ru/PLN-919).
Все это выполняется вручную сотрудником подразделения Группа планирования и управления ресурсами.

*Важно!*: если зарегистрироваться в Azure, получить 200$, создать на них ресурсы в Azure,
а затем перейти на корпоративный биллинг, то созданные ранее ресурсы автоматически перейдут на корпоративный биллинг
и деньги будут списываться с корпоративного billing аккаунта.

Troubleshooting:

1) IDM пишет, что роль выдана, 30 минут прошло, а в Azure пользователь в AD группе не появился.
   При возникновении такой ситуации нужно узнать у Win Админов (Группа инфраструктуры Microsoft),
   добавился ли фактически юзер в AD группу в on-prem AD.
