## Crossplane

Crossplane позволяет управлять облаками/подписками/AWS account-ами и ресурсами в них
с использованием единого подхода:

1. выбрать шаблон (yaml файл) требуемого ресурса (ВМ, Postres, k8s, ObjectStorage и тп)
2. поменять его содержимое в соответствие с тем, ресурс с какими настройками необходимо создать
(например, для ВМ указать нужное кол-во памяти и ядер)
3. запустить создание ресурса командой kubectl apply с указанием этого файла
   (kubectl стандартная утилита управления кластером k8s)
4. убедиться, что ресурс создан успешно командой kubectl get или kubectl describe

Crossplane умеет взаимодействовать с облаками разных вендоров (Yandex.Cloud, AWS, Azure, GCP и тп),
создавать там ресурсы и получать их статусы. Шаблоны ресурсов для разных вендоров отличаются,
но по каждому вендору можно получить описание любого поля в yaml файле ресурса с использованием
kubectl explain. Кроме того, по файлам ресурсов есть документация.

Crossplane может подключаться к управлению ресурсами, созданными вне Crossplane.
Для этого необходимо описать созданные ресурсы через шаблоны ресурсов. После
исполнения kubectl apply ресурс становится управляемым через Crossplane.

Планируется, что процессы создания облаков/подписок/AWS account-ов, сервисных аккаунтов,
управление ролями для юзеров и СА и тд также будут управлять через Crossplane.

Более подробная информация по [ссылке](https://a.yandex-team.ru/arc/trunk/arcadia/infra/kube)
