# Ответы на наиболее часто задаваемые вопросы

Здесь сформулированы наиболее часто задаваемые вопросы и ответы на них. В случае если Вы не нашли ответ
на какой-то вопрос или имеющийся ответ не совсем понятен, или Вы не уверены, что все понимаете правильно,
то обращайтесь к kaganovich1@yandex-team.ru

## Что такое YC роли? Как их получать?

Вместо стандартного IAM набора ролей, предоставляемых в облаке, используем YC роли. YC роли запрашиваются и выдаются через ABC сервис. Для каждой YC роли СИБом согласован маппинг на
набор IAM ролей в Yandex.Cloud. 
Маппинг доступен по  ссылке: [маппинг](https://wiki.yandex-team.ru/yc4y-t/abc-to-iam-role-mapping/)

## Что такое Яндекс организация? Какие облака в ней располагаются? Как переехать в организацию Яндекс?

В конце 2021 года в Yandex.Cloud появилось понятие организации как еще один уровень над облаками.
Новые облака без организации создать нельзя, а старые облака надо мигрировать в созданную
организацию Яндекс.

В соответствии с [планами](https://clubs.at.yandex-team.ru/cloud/2217), в организации
Яндекс будут все облака, связанные с сервисами Яндекса. Миграция будет осуществляться централизованно
и отдельно по каждому облаку.

Особенностью организации Яндекс является единая федерация, в которой будут только сотрудники Яндекса.
Поэтому если у облака была создана своя отдельная федерация, то при миграции все юзеры этой федерации будут смигрированы на федерацию Яндекса.
После миграции для захода в облако необходимо использовать [URL](https://console.cloud.yandex.ru/federations/bpf301hnejf1t12ndk5m).

## Почему юзерам в облаке организации Яндекс нельзя назначать роль admin?

Есть правила жизни в Яндекс облаке, согласованные СИБ [правила жизни в облаке](https://wiki.yandex-team.ru/security/policies/yandex-cloud-rules).
Роль admin позволяет назначать роли в облаке, что является небезопасным и приводит к
бесконтрольной ручной выдаче ролей. Чтобы это предотвратить роль admin не выдается.
Более подробно смотри [ссылку](https://wiki.yandex-team.ru/security/policies/yandex-cloud-rules/#avtorizacijavjandeksoblakeiamroli)

## Как создать сервисный аккаунт (СА) и назначить ему роли?

### Создание сервисного аккаунта

На первом этапе необходимо [создать сервисный аккаунт через консоль облака](https://cloud.yandex.ru/docs/iam/operations/sa/create) (для того, чтобы суметь создать сервисный аккаунт, необходимо предварительно запросить себе роль YC Administrator через сервис [ABC](https://abc.yandex-team.ru/)) или с использованием CLI:
```markdown
yc iam access-key create --service-account-name <имя_сервисного_аккаунта> --description <"сервисный аккаунт для работы с компонентом BlaBlaBla">
```
{% note info %}

Для создания СА необходимо запросить временную роль YC Administrator с указанием того, для чего нужна эта роль.
СИБ выдаст эту роль, но временно. Роли YC Administrator соответствует IAM роль editor, которая позволяет
создавать СА, но не позволяет назначать ему роли

{% endnote %}

### Назначение роли сервисному аккаунту

Рекомендуемый способ назначения ролей: создание тикета в саппорт. [Пример](https://st.yandex-team.ru/CLOUDSUPPORT-128911)

#### Самостоятельное формирование запроса на внесение изменений в конфигурацию iam-sync

{% note warning %}

Внимание: Вместо выполнения действий по данному пункту, можно завести тикет по по аналогии с [тикетом](https://st.yandex-team.ru/CLOUDSUPPORT-128911).
Если формируете запрос на изменение файла самостоятельно, будьте аккуратны

{% endnote %}

Необходимо сходить в [iam-sync-configs](https://bb.yandex-team.ru/projects/CLOUD/repos/iam-sync-configs/) и сделать PR внеся соответствующие изменения. Самостоятельно из веб-консоли накинуть нужные роли у вас не получится, так как управление ими осуществляется через [iam-sync-configs](https://bb.yandex-team.ru/projects/CLOUD/repos/iam-sync-configs/).

Cтруктуру записей, чтобы эти самые изменения внести, можно помсмотреть [здесь](https://wiki.yandex-team.ru/YC4Y-T/yandex-team-federation/#role-mapping-template)

Для примера: запись, которая дает сервисной учетной записи права editor на облако

```markdown
- roles: ["editor"]

service_accounts:

- <имя_сервисного_аккаунта> #сервисный аккаунт для работы с облаком/компонентом <BlaBlaBla>
```

После внесения изменений  конфиг необходимо выполнить билд и создать запрос на слияние. Слияние происходит после всех билдов (не только вашего измнения), но после слияния максимум в течение получаса ваша сервисная учетная запись получит нужные роли.

## Как создать folder (фолдер) в облаке?

Для создания folder в облаке необходимо запросить роль YC Administrator с указанием того, для чего нужна эта роль.
СИБ выдаст эту роль, но временно. Роли YC Administrator соответствует IAM роль editor, которая позволяет
создавать folder.

## В синке много yaml файлов - в какой файл синка необходимо добавлять yaml блоки для облаков организации Яндекс?

В файл [prod-yandex.yaml](https://bb.yandex-team.ru/projects/CLOUD/repos/iam-sync-configs/browse/prod-yandex.yaml)

## Есть ли стандартный yaml блок, который необходимо добавить в файл синка с маппингом YC ролей на IAM роли?

Да, такой файл доступен по [ссылке](https://wiki.yandex-team.ru/yc4y-t/yandex-team-federation/).

## Что будет если не указал фолдер/облако в синке

К нему просто не будет доступа. Только надо учитывать, что права наследуются от облака к фолдерам. Например, если облако под синком и у юзера есть роль viewer на облако, то за счет наследования прав у юзера будет роль viewer на каждый фолдер этого облака. Поэтому даже если фолдер в синке не указать, то не факт, что к нему не будет доступа.

## Заказ сетевого макроса и получение ipv6 адресации
Сетевые макросы привязываются к [projectid](https://docs.yandex-team.ru/nocdoc/processes/project_id/about). Макрос заказывается с использованием [формы](https://st.yandex-team.ru/createTicket?queue=CLOUD&_form=54816).
Если нет projectid или требуется новый, то можно проставить соответствующую галочку в конце формы. 
Сетевую адресацию необходимо заказывать с использованием [шаблона](https://st.yandex-team.ru/createTicket?queue=YCLOUD&_form=109919)

## Создание ВМ с сетевым интерфейсом dualstack (ipv4+ipv6) / добавление ipv6 к существующему интерфейсу
Для создания первых ВМ проще всего воспользоваться [Yandex Cloud CLI](https://cloud.yandex.ru/docs/cli/quickstart)
Образы лучше использовать [Golden Image for Yandex CLoud](https://wiki.yandex-team.ru/security/policies/yandex-cloud-rules/golden-image/)
Если требуется создание ВМ на основе общедоступого образа, их список можно просмотреть командой 
```markdown
yc compute image list --folder-id standard-images
```

#### Создать ВМ с ОС Windows можно, например, с помощью команды 

```markdown
yc compute instance create <имя_ВМ> --metadata-from-file user-data=metadata.yaml --zone <'зона_доступности_напр:ru-central1-a'> --create-boot-disk name=<название_диска>,type=<типа_диска_напр:network-ssd>,size=<размер_в_Г>,image-id=<образ_ВМ_напр:fd803730irifbddaarmi> --network-interface subnet-id=<ID_подсети>,ipv4-address=auto,ipv6-address=auto --memory <опер_память> --cores <ядра>
```
Причем, необходимо заранее подготовить файл для задания пароля пользователя Administrator. Подробности в разделе CLI [статьи по ссылке](https://cloud.yandex.ru/docs/compute/operations/vm-create/create-windows-vm)

####  ВМ с ОС Linux - командой

```markdown
yc compute instance create <имя_ВМ> --zone <зона_доступности_напр:'ru-central1-a'> --ssh-key <публичный_ключ_RSA_напр:.ssh/id_rsa.pub --create-boot-disk name=<имя_диска>,type=<тип_диска_напр:network-ssd>,size=<размер_диска_в_Г>,image-id=<образ_ВМ_напр:fd803730irifbddaarmi> --network-interface subnet-id=<ID_подсети>,ipv4-address=auto,ipv6-address=auto --memory <опер_память> --cores <ядра>
```
Здесь, необходимо в локльной файловой системе иметь публичную чать RSA ключа, по указанному в команде пути 

#### Для уже существующей ВМ можно обновить сетевой интерфейс, добавив ipv6 адрес командой

```markdown
yc compute instance update-network-interface <имя_ВМ> --network-interface-index 0 --ipv6-address=auto
```

## Настройка Security Group для доступа к сетям ipv6
Группы безопасности можно предварительно создать через веб-консоль, но есть вероятность, что при создании вы не увидите там формы для ввода правил с ipv6 CIDR

Для добавления правил в такие уже созданные SG можно воспользоваться команадами, типа

```markdown
yc vpc security-group update-rules --name=<название_SG> --add-rule "direction=egress,protocol=any,port=any,v6-cidrs=::/0"
```
Синтаксис тут такй же, как и при обычном [создании правил через CLI](https://cloud.yandex.ru/docs/vpc/operations/security-group-create), но добавляются 'v6-cidrs'

Если ваш сервис предполагает автоматическое создание виртуальных машин, при этом у вас не будет возможности указывать при создании этих машин конкретные SG, то есть смысл воспользоваться таковой дефолтной - она будет автоматически назначаться всем вновь создаваемым ВМ, если не укзаны конкретные SG в запросе их создания. Либо же, используя дефолтную SG, можно отделить этот куcочек настроек от настроек непосредственно самого приложения (например, для разграничения доступа). В этом случае необходимо обратиться к коллегам из поддержки сети - они создадут вам дефолтную группу вручную.
NB! Для уже созданных ВМ данные группы постфактум не прилетят. Надо будет их вешать вручную.

## Дополнительная настройка сети для работы с Active Directory
Если есть необходимость доступа к домен-контроллерам и введения ваших машин в домен, то дополнительно необходимо произвести настройку DHCP, чтобы у вас в машинки прилетали нужные DNS серверы и сам домен

```markdown
yc vpc subnet update <имя_подсети> --domain-name local
```

NOTE: в случае, если домен называется blabla.local, то в настройках необходимо указывать только первый уровень - остальное вытащится из DNS. Иначе есть риск получить запись, типа  "blabla.local.local".

DNS серверы можно прописать схожей командой

```markdown
yc vpc subnet update <имя_подсети> --domain-name-server <ipv6_addr_dc1>[,<ipv6_addr_dc2>]
```

все поля, которые можно прописать в опциях, можно найти по [странице из докумнетации](https://cloud.yandex.com/en/docs/cli/cli-ref/managed-services/vpc/subnet/update)

## Получение сетевого доступа к внутренним ресурсам Yandex (на примере Active Directory)
Для того, чтобы можно было воспользоваться настройками сделанными на предыдущем шаге, необходимо воспользоваться сервисо [Puncher](https://puncher.yandex-team.ru/)

В качестве источника необходимо указать название сети (макрос) вашего облака, использовавшееся при создании сетей через ycp. Также его можно найти в iam конфиге. Если там неуспех - посмотрите в описании ресурсов соответствующего сервиса АВС.

В общем случае, для того чтобы ваши ВМ кооректно вводились в домен, необходимо открывать [порты, перечисленные в статьях Microsoft](https://docs.microsoft.com/en-us/troubleshoot/windows-server/identity/config-firewall-for-ad-domains-and-trusts) или [в другой статье](https://docs.microsoft.com/en-us/troubleshoot/windows-server/networking/service-overview-and-network-port-requirements#active-directory-local-security-authority)

Некоторые из перечисленных портов у нас не используются.

Не должно возникнуть проблем с согласованием указаных ниже портов с СИБ (и с доменом при этом должно корректно все взаимодействовать - порты выяснили опытным путем)

Если нужно пробиваться в сторону КД, то необходимо запросить правила со следующими "дырками":

```markdown
TCP: 53, 389, 88, 464, 636, 3268, 3269, 445, 135, 49152-65535 UDP: 53, 389, 88, 464
```

В качестве приемника указываете либо конкретные координаты серверов КД (ipv6 адреса), либо макрос
