package main

import (
	"fmt"
	"html/template"
	"net/http"
	"time"
)

func (s *server) HandleRoot() http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		logs, err := s.db.GetLogs()
		if err != nil {
			panic(err)
		}
		l := &AccessLog{
			Host: r.RemoteAddr,
			Time: time.Now(),
		}
		if err := s.db.SaveLog(l); err != nil {
			panic(err)
		}

		text := `
<h1>Access log</h1>
<ul>
    {{range .}}
        <li>{{.Id}} {{.Host}} {{.Time}}</li>
    {{end}}
</ul>`
		type templateLogStruct struct {
			Id   string
			Host string
			Time string
		}
		templateLogs := make([]*templateLogStruct, 0)
		for _, log := range logs {
			templateLogs = append(templateLogs, &templateLogStruct{Id: fmt.Sprintf("%d", log.Id), Host: log.Host, Time: log.Time.Format(time.RFC822)})
		}
		t, err := template.New("foo").Parse(text)
		if err != nil {
			panic(err)
		}
		err = t.ExecuteTemplate(w, "foo", templateLogs)
		if err != nil {
			panic(err)
		}
	}
}
