package main

import (
	"database/sql"
	"time"
)

type datastore struct {
	db *sql.DB
}

func (d *datastore) Init() error {
	const schema = `
CREATE TABLE IF NOT EXISTS access_logs (
  id   SERIAL    PRIMARY KEY,
  host TEXT      NOT NULL,
  time TIMESTAMP NOT NULL
)`
	_, err := d.db.Exec(schema)
	return err
}

type AccessLog struct {
	Id   int `json:"id"`
	Host string `db:"host"`
	Time time.Time `db:"time"`
}

func (d *datastore) SaveLog(log *AccessLog) error {
	_, err := d.db.Exec("INSERT INTO access_logs (host, time) VALUES ($1, $2)", log.Host, log.Time)
	return err
}

func (d *datastore) GetLogs() ([]*AccessLog, error) {
	rows, err := d.db.Query("SELECT id, host, time FROM access_logs")
	if err != nil {
		return nil, err
	}
	logs := make([]*AccessLog, 0)
	for rows.Next() {
		accessLog := &AccessLog{}
		if err := rows.Scan(&accessLog.Id, &accessLog.Host, &accessLog.Time); err != nil {
			return nil, err
		}
		logs = append(logs, accessLog)
	}
	return logs, err
}
