package main

import (
	"fmt"
	"log"
	"net/http"

	"github.com/go-chi/chi/v5"
)

type server struct {
	db     *datastore
	router chi.Router
}

const appPort = 80

func main() {
	log.Printf("Listening on port %d\n", appPort)
	s := &server{}
	s.setupRoutes()
	if err := s.setupDB(); err != nil {
		panic(err)
	}
	log.Fatal(http.ListenAndServe(fmt.Sprintf(":%d", appPort), s.router))
}
