package main

import (
	"database/sql"
	"fmt"
	"log"
	"os"

	_ "github.com/lib/pq"
)

func (s *server) setupDB() error {
	log.Println("Setting up db....")

	host := os.Getenv("PGHOST")
	port := os.Getenv("PGPORT")
	user := os.Getenv("PGUSER")
	password := os.Getenv("PGPASSWORD")
	dbname := os.Getenv("PGDATABASE")
	psqlInfo := fmt.Sprintf("host=%s port=%s user=%s password=%s dbname=%s sslmode=disable",
		host, port, user, password, dbname)
	log.Printf("Connecting to '%s'\n", psqlInfo)
	db, err := sql.Open("postgres", psqlInfo)
	if err != nil {
		return err
	}
	store := &datastore{
		db: db,
	}
	if err := store.Init(); err != nil {
		return err
	}
	s.db = store
	log.Println("Success")
	return err
}
