package main

import (
	"fmt"
	"log"
	"net/http"
	"os"
	"time"

	"github.com/go-chi/chi/v5"
)

type server struct {
	db     *datastore
	router chi.Router
}

const appPort = 80

func main() {
	log.Printf("Listening on port %d\n", appPort)
	s := &server{}
	s.setupRoutes()
	if err := s.setupDB(); err != nil {
		panic(err)
	}
	t := time.NewTicker(time.Minute)
	if err := ensureDir("static"); err != nil {
		panic(err)
	}
	// init first time
	if err := s.db.Sync(); err != nil {
		fmt.Printf("Failed to sync objects: %s\n", err)
	}
	go func() {
		select {
		case <-t.C:
			if err := s.db.Sync(); err != nil {
				fmt.Printf("Failed to sync objects: %s\n", err)
			}
		}
	}()
	log.Fatal(http.ListenAndServe(fmt.Sprintf(":%d", appPort), s.router))
}

func ensureDir(dirName string) error {
	err := os.Mkdir(dirName, 0777)
	if err == nil {
		return nil
	}
	if os.IsExist(err) {
		// check that the existing path is a directory
		info, err := os.Stat(dirName)
		if err != nil {
			return err
		}
		if !info.IsDir() {
			return fmt.Errorf("path exists but is not a directory")
		}
		return nil
	}
	return err
}
