package main

import (
	"fmt"
	"github.com/go-chi/chi/v5"
	"html/template"
	"net/http"
)

func (s *server) HandleRoot() http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		keys := s.db.Keys()
		text := `
<h1>S3 objects listing</h1>
<ul>
    {{range .}}
        <li><a href=/{{.Key}}>{{.Key}}</a></li>
    {{end}}
</ul>`
		type templateKeysStruct struct {
			Key string
		}
		templateLogs := make([]*templateKeysStruct, 0)
		for _, k := range keys {
			templateLogs = append(templateLogs, &templateKeysStruct{Key: k})
		}
		t, err := template.New("foo").Parse(text)
		if err != nil {
			panic(err)
		}
		err = t.ExecuteTemplate(w, "foo", templateLogs)
		if err != nil {
			panic(err)
		}
	}
}

func (s *server) HandleObject() http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		name := chi.URLParam(r, "object")
		text := `
<h1>S3 object: '{{.Name}}'</h1>
{{.Content}}
`
		type templateObjectStruct struct {
			Name    string
			Content string
		}
		content, err := s.db.Object(name)
		if err != nil {
			fmt.Printf("Failed to read object: %s\n", err)
			w.WriteHeader(500)
			return
		}
		t, err := template.New("foo").Parse(text)
		if err != nil {
			panic(err)
		}
		err = t.ExecuteTemplate(w, "foo", &templateObjectStruct{Content: string(content), Name: name})
		if err != nil {
			panic(err)
		}
	}
}
