package main

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"log"
	"os"

	_ "github.com/lib/pq"
)

func (s *server) setupDB() error {
	log.Println("Setting up db...")
	bucket := os.Getenv("S3_BUCKET_NAME")
	region := "us-west-2"
	if r := os.Getenv("S3_REGION"); r != "" {
		region = r
	}
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String(region)},
	)
	if err != nil {
		return err
	}
	store := &datastore{
		s:         sess,
		bucket:    bucket,
		uploadDir: "static",
	}
	s.db = store
	log.Printf("DB setup finished with: region='%s' bucket='%s'\n", region, bucket)
	return err
}
