resource "yandex_iam_service_account" "provider-jet-yc-sa" {
  name        = "provider-jet-yc-preprod"
  description = "Service account for crossplane PREPROD provider-jet-yc"
}

resource "yandex_resourcemanager_folder_iam_binding" "provider-jet-yc-editor" {
  folder_id = data.yandex_resourcemanager_folder.crossplane-preprod.id

  role = "editor"

  members = [
    "serviceAccount:${yandex_iam_service_account.provider-jet-yc-sa.id}",
  ]
}

resource "yandex_resourcemanager_folder_iam_binding" "provider-jet-yc-iam-admin" {
  folder_id = data.yandex_resourcemanager_folder.crossplane-preprod.id

  role = "iam.serviceAccounts.admin"

  members = [
    "serviceAccount:${yandex_iam_service_account.provider-jet-yc-sa.id}",
  ]
}
