resource "yandex_kubernetes_cluster" "crossplane-preprod-kubernetes" {
  name        = "crossplane-preprod"
  description = "Crossplane PREPROD kubernetes cluster"

  network_id = yandex_vpc_network.crossplane-preprod-nets.id

  master {
    regional {
      region = "ru-central1"

      location {
        zone      = yandex_vpc_subnet.crossplane-preprod-net-a.zone
        subnet_id = yandex_vpc_subnet.crossplane-preprod-net-a.id
      }

      location {
        zone      = yandex_vpc_subnet.crossplane-preprod-net-b.zone
        subnet_id = yandex_vpc_subnet.crossplane-preprod-net-b.id
      }

      location {
        zone      = yandex_vpc_subnet.crossplane-preprod-net-c.zone
        subnet_id = yandex_vpc_subnet.crossplane-preprod-net-c.id
      }
    }

    version   = "1.21"
    public_ip = true

    maintenance_policy {
      auto_upgrade = true

      maintenance_window {
        start_time = "5:00"
        duration   = "3h"
      }
    }
  }
  service_ipv4_range = "10.6.0.0/16"
  cluster_ipv4_range = "10.5.0.0/16"

  node_ipv4_cidr_mask_size = "24"

  service_account_id      = yandex_iam_service_account.crossplane-sa.id
  node_service_account_id = yandex_iam_service_account.crossplane-sa.id

  release_channel = "RAPID"
}
