resource "yandex_vpc_network" "crossplane-preprod-nets" {
  name        = "crossplane-preprod-nets"
  description = "Crossplane preprod nets"
}

resource "yandex_vpc_subnet" "crossplane-preprod-net-a" {
  name           = "crossplane-preprod-net-a"
  description    = "Crossplane preprod subnet a"
  v4_cidr_blocks = ["10.1.0.0/16"]
  zone           = "ru-central1-a"
  network_id     = yandex_vpc_network.crossplane-preprod-nets.id
}


resource "yandex_vpc_subnet" "crossplane-preprod-net-b" {
  name           = "crossplane-preprod-net-b"
  description    = "Crossplane preprod subnet b"
  v4_cidr_blocks = ["10.2.0.0/16"]
  zone           = "ru-central1-b"
  network_id     = yandex_vpc_network.crossplane-preprod-nets.id
}


resource "yandex_vpc_subnet" "crossplane-preprod-net-c" {
  name           = "crossplane-preprod-net-c"
  description    = "Crossplane preprod subnet c"
  v4_cidr_blocks = ["10.3.0.0/16"]
  zone           = "ru-central1-c"
  network_id     = yandex_vpc_network.crossplane-preprod-nets.id
}
