resource "yandex_kubernetes_node_group" "crossplane-preprod-nodegroup" {
  cluster_id  = yandex_kubernetes_cluster.crossplane-preprod-kubernetes.id
  name        = "crossplane-preprod-a1"
  description = "Crossplane PREPROD kubernetes nodegroup a-1"
  version     = "1.21"

  instance_template {
    platform_id = "standard-v2"

    network_interface {
      nat        = true
      ipv4       = true
      subnet_ids = [yandex_vpc_subnet.crossplane-preprod-net-a.id]
    }

    resources {
      memory = 4
      cores  = 2
    }

    boot_disk {
      type = "network-hdd"
      size = 64
    }

    metadata = {
      ssh-keys = "vaspahomov:ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC3qNbyyaTD3+coOtSuXMzhdwrICTyAqZ2tWYGS9FDXN3XNMnL9Et7uIraQcAjJ0GOT9eXHI67ppdzbjtQZTNV7lqr+qqRhE9kG67WWvBwX5DtsS7EODv94k5w6lYQzlv/H6VubRciMqzjXnX9T1jjO2reDIlcS8F87PFCR9tNTCrsBW7Juo/DaSG/3p5k90ky/VkRaf/f5dbvOM4Swy7/hNC940iYIdZZ64fek1wZBT4fe0FscvlnK0QPFFSRDyk0VivJhFyhWen/Ea9dJiKXPQ+OVMPIVctE41WR6OPz3KMrEIQsgNHfXpFEs1u0TVGho96viwteqx/f3X8PFVWWJ vaspahomov@yandex-team.ru"
    }
  }

  scale_policy {
    auto_scale {
      min     = 1
      max     = 3
      initial = 1
    }
  }

  allocation_policy {
    location {
      zone = "ru-central1-a"
    }
  }

  maintenance_policy {
    auto_upgrade = true
    auto_repair  = true

    maintenance_window {
      start_time = "5:00"
      duration   = "3h"
    }
  }
}
