resource "yandex_iam_service_account" "crossplane-sa" {
  name        = "crossplane-preprod-k8s"
  description = "Service account for crossplane PREPROD kubernetes cluster"
}

resource "yandex_resourcemanager_folder_iam_binding" "crossplane-k8s-agent" {
  folder_id = data.yandex_resourcemanager_folder.crossplane-preprod.id

  role = "k8s.clusters.agent"

  members = [
    "serviceAccount:${yandex_iam_service_account.crossplane-sa.id}",
  ]
}

resource "yandex_resourcemanager_folder_iam_binding" "crossplane-lb-admin" {
  folder_id = data.yandex_resourcemanager_folder.crossplane-preprod.id

  role = "load-balancer.admin"

  members = [
    "serviceAccount:${yandex_iam_service_account.crossplane-sa.id}",
  ]
}

resource "yandex_resourcemanager_folder_iam_binding" "crossplane-vpc-admin" {
  folder_id = data.yandex_resourcemanager_folder.crossplane-preprod.id

  role = "vpc.admin"

  members = [
    "serviceAccount:${yandex_iam_service_account.crossplane-sa.id}",
  ]
}


resource "yandex_resourcemanager_folder_iam_binding" "crossplane-registry-puller" {
  folder_id = data.yandex_resourcemanager_folder.crossplane-preprod.id

  role = "container-registry.images.puller"

  members = [
    "serviceAccount:${yandex_iam_service_account.crossplane-sa.id}",
  ]
}
