**TL;DR**: истории нет, есть подходы для отката и механизмы аудита
# History
Во многие текущие control plane'ы встроена история изменений объектов. Примеры:
  * Nanny
  * AWACS
  * YP (API и логика требуют доработки, но базово работает)
При этом в Juggler/Yasm истории штатно нет (недоступна пользователю). User story можно сформулировать так.
Аудит:
>Я, как пользователь системы, хочу понимать кто и как менял конкретные объекты в указанном временном интервале.

Rollback:
>Я, как пользователь системы, хочу уметь откатывать систему не предыдущее стабильное состояние.

Прямо сейчас k8s не даёт никакого доступа к истории изменений объектов. А доступ истории, с запросами, фильтрами и т.д. - важный элемент для расследования проблем, откатов и т.д.

# Реализация
Реализация будет в любом случае состоять из трёх частей:
  * Хранилище.
  * API/UI для чтения
  * Механизм выгрузки событий об изменении объекта.

Варианты:
  * В любом случае будет нужен будет другой механизм хранения (не etcd).
  Чтобы проблемы с историей (которая растёт) не влияли на working set, который примерно постоянный. Можно взять Mongo/PostgreSQL@MDB.
  * Хочется, чтобы API/UI были максимально теми же (FW, API, Authn/z). 
  Идеальный вариант - проксирование через API сервер.
  Тут нужно посмотреть в:
    * https://kubernetes.io/docs/tasks/access-application-cluster/access-cluster/#discovering-builtin-services
    * https://kubernetes.io/docs/concepts/extend-kubernetes/api-extension/apiserver-aggregation/
  * Поставка данных.
  Посмотреть на [механизм аудитных данных](https://kubernetes.io/docs/tasks/debug-application-cluster/audit/) через HTTP.