# Infrastructure models. Part 4.
Начав с пользователя мы к нему возвращаемся. Иногда пользователь - это большой человеко-машинный комплекс, который состоит из:
  * нескольких команд
  * различных приложений
  * источников данных

Например, внешних партнёров с сильно ограниченными средстами для интеграции  **_событий_**.

И уложить всё в один `kubectl apply -f` может быть нетривиально. Дать удобную декларативную модель для некоторых случаев может быть проблематично, либо это будет слишком дорого.

## Base stories
Т.к. наша задача описательная - т.е. посмотреть на реальность и сформулировать подходящую (полезную) модель, то давайте посмотрим на несколько пользовательских сценариев.

>Мои сервисы сложны и я хочу ввести свои собственные абстракции, чтобы инженеры могли точно выражать мысли в терминах БК, а не сервисов Няни или deploy unit'ов Deploy'я. Так мы сможем не ошибаться, держа "маппинг" в голове каждого инженера.

Это очень понятный кейс, вопрос наверное может быть такой. Если это код, то ему нужен процесс (тред со стэком), который будет этот код интерпретировать. Если так, то кто, где и по какому событию будет этот код запускать. Давайте посмотрим на варианты:
>После выпуска новой версии дежурный меняет описание сервиса на Python'е (либо указывает её в нужном формате в условном .ini файле) и запускает `ya make samogon/bk-contour-deploy`, который сформирует описание объектов в терминах nanny/deploy/k8s, отправит на выкладку и будет ждать окончания.

Зачастую выкладки - это многоступенчатый процесс, возможно история дополняется:
>...сформирует описание объектов в терминах nanny/deploy/k8s для первого этапа, отправит на выкладку, будет ждать окончания и перейдёт к следующему этапу - нам нужны *сценарии*.
>Таким образом в коде получится цикл вида:
>`for step in generate_steps(binary_version):`
>`    execute(step)`

Такой подход в распределённой команде может привести к проблемам:
  * несколько пользователей запустили конфликтующие изменения
  * кто-то начал выкладку и найти источник изменений нетривиально
Т.е. система у нас на самом деле распределённая и задача потенциально усложнилась, решением могут быть:
  * договорённости в чате/тикете
  * запуск процесса в CI/CD системе, которая гарантирует single writer'а

## Complete stories
В перечисленных кейсах мы не артикулировали одну деталь у нас *событием* был "релиз новой версии", а *отреагировал* на событие - инженер. Но события бывают разные:
  * повторяющиеся регулярно или стохастически
  * частые или очень редкие
  * происходящие в рабочие часы и не очень
  * требующие дорогого времени инженера или нет
Т.е. реакция на события - подходящий кандидат на автоматизацию. Модельно нам нужно:
  * реализовать триггер на событие (HTTP запрос от внешних партнёров, изменение ключа в Кипарисе и т.д)
  * триггер в свою очередь:
    * либо трансформирует событие в формат, понимаемый CI/CD системой
    * самостоятельно запустит //сценарий// выкладки в своём процессе
    * самостоятельно внесёт изменения в объект системы выкладки

## Sequences all the way down
Если присмотреться, то можно заметить, что CI/CD состоит из *последовательности* действий, которая запускается на событие *релиза*:
```
┌──────┐
│CI/CD │
├──────┴────────────────────────────────┐
│                                       │
│  Deploy ──┐                           │
│           │                           │
│           │► Wait────►Deploy────►Done │
│           │                           │
│  Deploy ──┘                           │
│                                       │
└───────────────────────────────────────┘
```
Давайте увеличим масштаби и посмотрим на отдельный этап `Deploy`, где мы ожидаем от контроллера системы выкладки завершения события:
```
┌──────┐
│CI/CD │
├──────┴───────────────────────────────────────────────────────────┐
│                                                                  │
│  ┌──────┐                                                        │
│  │Deploy│                                                        │
│  ├──────┴─────────────────────┐                                  │
│  │                            │                                  │
│  │UpdatePod ──┐               │                                  │
│  │            ├──►Wait───►Done├─────┐                            │
│  │UpdatePod ──┤               │     │                            │
│  │            │               │     │► Wait────►Deploy────►Done  │
│  │   ...                      │     │                            │
│  └────────────────────────────┘     │                            │
│                                     │                            │
│                                     │                            │
│                                     │                            │
│                        Deploy ──────┘                            │
│                                                                  │
└──────────────────────────────────────────────────────────────────┘
```
Он занимается тем же. Мы видим повторяющийся (рекурсивный, *фрактальный*?) паттерн
  * у нас есть сценарий в CI/CD, который управляет Deployment'ами
  * внутри объекта Deployment сценарий, который оркестрирует ReplicaSet'ами
  * те, в свою очередь идут по сценарию, "перещёлкивая" Pod'ы
  * `kubelet`/`node-agent` на конечных хостах оркестрирует запуск контейнеров Pod'а

Вот такая [scale independent](https://en.wikipedia.org/wiki/Scale_invariance) система получается. [Universality](https://en.wikipedia.org/wiki/Universality_(dynamical_systems)) потенциально интересная и многообещающая область для рассуждений, но мы попробуем не отвлекаться настолько.

Из полезного видится наблюдение: мы имеем систему исполнения вложенных сценариев и в общем случае вывести то, как **должна** быть организована система:
  * если разные сервисы - то какие
  * как их композировать
  * где они должны быть запущены
  * как должны быть разделены зоны ответственности между сервисами и командами
скорее всего нельзя. Тут можно даже вспомнить Дэвида Хьюма с [is-ought](https://en.wikipedia.org/wiki/Is%E2%80%93ought_problem) проблемой.

Но два обстоятельства нам помогут:
  * мы инженеры и нам достаточно работающего **в нашем случае** решения
  * мы software инженеры - зачастую наши решения можно поменять, перекомпоновать достаточно оперативно  
  и даже не обязательно *с нуля*!

Т.е. можем идти аккуратно, одновременно в нескольких направлениях, проверяя гипотезы и backtrack'ая в случае проблем. Какие видятся направления?

Но перед этим **fun fact**: рекурсия на этом аспекте не заканчивается. Все перечисленные исполнители скриптов сами запущены в облаке, их самих так же **нужно выкладывать**. Это важный инженерный аспект, который ограничивает (ну или должен) желание выкатить свою собственную систему оркестрации. Поэтому задача инфраструктуры - сделать всё необходимое, чтобы пользователям не приходилось изобретать подобное. Но если всё же нужно, то как?

## Just use the API
Все системы (построенные на Nanny/YP/K8s) дают API и позволяют пользователям решить свои проблемы, ввести свои абстракции и pipeline'ы сценариев, например:
  * компоненты/инсталляции ЦУМ'а поверх сервисов Няни
  * скрипты katalka у Толоки

Из плюсов:
  * Доступность уже сейчас.
  * Свобода действий, возможность организовать практически любой сценарий с реакцией на любые события.

вытекают минусы:
  * Огромные затраты организовать такие pipeline'ы.
  * Поддержка сервиса - это процесс, который будет отнимать время инженеров.
  * Сложно композировать с другими абстракциями (например, сервисы Такси, инсталляции ЦУМа)

Этот сценарий требует больших инвестиций и скорее недоступен для небольших команд.

TODO инфраструктуры:
  * Дать как можно более единообразный API  
  Чтобы писать и поддерживать такие сервисы (они есть и долго будут с нами) было проще, а сами сервисы были надёжны.

## CI/CD
Посмотрим на противоположный полюс и попробуем взять максимально готовые компоненты. Сценарии замечательно выполняет CI/CD. Единственное, что нам нужно - научить его реагировать на произвольные события. Для этого "наш код" - это трансляция внешних событий в коммиты в репозиторий (*everything is a ~~file~~commit*).
Плюсы:
 * мы пишем минимум своего кода - обработчик события

Минусы (потенциально):
 * мы пишем минимум своего кода
 Мы люди и у людей есть чувства, не все они положительные по отношению к YAML. На самом деле: отлаживать большие YAML'ы очень нетривиально.
 * сценарии редко масштабируются на тысячи сущностей ("обновить версию балансера во всех сервисах под управлением AWACS")
 * сценарии достаточно ригидные (начать выкладку быстрой базы сервиса на новые инстансы в %DCNAME%)

TODO инфраструктуры:
  * Дать возможность хранить спецификации объектов в репозитории  
  Это доступная опция сейчас, но она точно не first-class citizen.
  * Дать возможность отправлять "patch'и" в объекты, чтобы не переписывать их польностью 
  Если мы хотим дать возможность по событию поправить "часть объекта". См. [https://github.com/kubernetes/community/blob/master/contributors/devel/sig-api-machinery/strategic-merge-patch.md](strategic-merge-patch).

## Middleground
Где-то между полюсами есть ниша для систем, которые с одной стороны позволяют **описать сценарии императивно**, с другой - дать framework и среду, которая позволяет сосредоточиться на бизнес логике и упрощает эксплуатацию. Ручку баланса можно крутить в разные стороны достаточно малыми шагами, мы качестве примера посмотрим на следующие варианты.

### Operator Framework
Если вспоминать kubernetes, то мы можем использовать большой и богатый [kubebuilder](https://book.kubebuilder.io/) framework, на котором описать бизнес логику по оркестрации сервисов. Если другие объекты (сервисы, балансеры) тоже являются ресурсами kubernetes - то всё будет укладываться достаточно просто.
Плюсы:
  * Сильно меньше свободы и граблей, чем сервис с нуля.
  Но всё ещё достаточно для реализации практически любых задач.

Минусы:
  * Не изолирует от проблем с эксплуатацией и выкладкой.  
  Нужно самому масштабировать, выкладывать как сервис и т.д.
  * Не все (пока?) в kubernetes!

### Temporal
Задачи выкладки/оркестрации могут быть разными и envelop может быть:
  * от секунд до недель по времени
  * от единицы до тысяч объектов
  * и т.д.
Интересно посмотреть на такую технологию [Temporal](https://temporal.io/), которая описывается как:
>platform for orchestrating highly reliable, mission-critical applications at scale.

Многообещающе! TODO: дописать про откуда и зачем + какие кейсы выкладки кладутся на это.


### And many more...
Большая вариантивность и universality породили огромное количество доступных подходов. Из интересного у нас есть Sandbox, даже Nirvana - и они используются с разной степенью успешности. В opensource есть [Spinnaker](https://spinnaker.io/), который используется [даже в Google](https://www.youtube.com/watch?v=b4PFHj9s5F8).

## Outro
Вот, надеюсь, и всё. Эта часть была точно не исчерпывающей и в ней не удалось дать ответы на все вопросы. Как и любой дизайн (и обзор!)  - это вещь в контексте (Яндекса и облачных технологий в середине 2021г.) и достаточно субъективная. Но это точно неплохая отправная точка, которая поможет:
  * **нам** при дизайне, выборе и размышлениях о том, как организовать разные пользовательские сценарии
  * нашим **пользователям** понять наши сложности, мотивацию и контекст принятия тех или иных решений

Моё мнение, что только вместе мы сможем построить, если не great again инфраструктуру, то хотя бы ту, которой мы доверяем и понимаем.