# RouteQ CI/CD

## Задача:

* Код хранится в arcadia
* Код собирается внутри Яндекса через ya make + sandbox (YA_PACKAGE)
* Приложения выкладываются в контур Яндекса и в AWS

## CI/CD инфраструктура

### На стороне Яндекса

Остается без изменений. За исключением того, что для AWS переиспользуются запуск unit тестов и сборка образа на стороне
аркадии и CI/Sandbox.

Код приложений хранится в arcadia. Собирается штатными для инфраструктуры Яндекса инфструментами. На commit/PR в trunk
запускается pipeline с unit тестами + сборкой и push'ем docker образа в registry в AWS.

### На стороне AWS

В AWS независимая от Яндекса деплойная инфраструктура. CI/CD часть в AWS умеет независимо от инфраструктуры Яндекса
выкладывать существующие образы из AWS container registry (ECR).

* Для CI части используются pipeline'ы описанные в gitlab.
* Для CD части используется ArgoCD который применяет k8s манифесты из git в k8s.

![infra](assets/routeq-infra.png)

## CI/CD с точки зрения пользователя

![infra](assets/routeq-cicd.png)

Пайплайн разбит на 2 части - одна запускается на стороне Яндекса, вторая на стороне AWS. С точки зрения пользователя это
означает, что есть два независимых процесса, которые нужно запускать независимо.

## Юнит тесты и сборка (на стороне Яндекса)

Разработчик коммитит код в аркадию. На каждый коммит __автоматикой__ запускаются unit тесты + собирается и пушится образ
в AWS container registry ECR (с помощью YA_PACKAGE).

#### Релиз приложения (на стороне AWS)

* Создается PR в gitlab на изменение манифестов testing'а.
* После мержа PR запускаются интеграционные тесты.
* После прогона тестов в CI становится доступна ручная (запускается по подтверждению) job'а создающая PR на изменение
  манифестов для prod.
* Джоба создает PR описании которого есть статус выполнения тестов. (бейдж ок/не ок, ссылка на логи тестов, etc)

PS:
Штатный сценарий - следовать автоматике и не изменять манифесты прода руками. Только мержить созданые автоматикой PR'ы.
Но также остается возможность создать PR вручную на случай hotfix'а.

## Чуть больше технических подробностей

* Приватный канал сети Yandex-AWS

  Для пуша образов из сетей яндекса в AWS нужен приватный канал до приватных сетей в AWS. (Для того, чтобы ECR не было
  видно из интернета).

