#!/bin/bash

if [ "$#" -ne 1 ]; then
    echo 'Invalid arguments count. You should specify namespace.'
    echo
    echo 'Use: "create-ns.sh <namespace>"'
    exit 2
fi

SPEC=$(cat <<-_EOT_
apiVersion: v1
kind: Namespace
metadata:
  name: $1
_EOT_
)
echo "$SPEC" > "$1".yaml

kubectl apply -f "$1".yaml
