package orphanpolicy

# Global assignments
obj := input.review.object

bad_policy(policy) {
  policy != "Orphan"
}

# Fail if we have non-orphan deletion policy
violation[{"msg": msg}] {
  p := object.get(obj.spec, "deletionPolicy", "<not set>")
  bad_policy(p)
  msg := sprintf("must have spec.deletionPolicy: Orphan (got '%s')", [p])
}
