package orphanpolicy
#
# Mock objects for testing
#

input_params = {}

test_input_policy_not_set {  
  input := {
    "review": {
      "object": {
        "apiVersion": "kubernetes.yc.yandex-team.ru/v1alpha1",
        "metadata": {
          "namespace": "walle-prod"
        },
        "spec": {
        },
      },
    },
    "parameters": input_params,
  }
  results := violation with input as input
  count(results) > 0
}

test_input_policy_not_orphan {  
  input := {
    "review": {
      "object": {
        "apiVersion": "kubernetes.yc.yandex-team.ru/v1alpha1",
        "metadata": {
          "namespace": "walle-prod"
        },
        "spec": {
          "deletionPolicy": "DELETE THIS"
        },
      },
    },
    "parameters": input_params,
  }
  results := violation with input as input
  count(results) > 0
}

test_input_policy_ok {  
  input := {
    "review": {
      "object": {
        "apiVersion": "kubernetes.yc.yandex-team.ru/v1alpha1",
        "metadata": {
          "namespace": "walle-prod"
        },
        "spec": {
          "deletionPolicy": "Orphan"
        },
      },
    },
    "parameters": input_params,
  }
  results := violation with input as input
  count(results) == 0
}
