## About
Попробуем рассмотреть на возможные схемы/топологии организации работы нескольких облаков в Яндексе.

# User story
Яндекс пробует запускать международные проекты и в каких-то случаях физически сервисы будут запущены в публичных облаках: Yandex.Cloud, AWS, Azure, GCE. Мы хотим дать пользователям сервис/продукт/набор подходов для того, чтобы увеличить их team velocity и снизить стоимость (и время) запуска.

>Я как SRE/CTO своей группы/БЮ хочу иметь возможность //быстро и единообразно// разворачивать облачные инсталляции в различных облаках. Т.е. чтобы развёртывание и управление AWS минимально отличалось от Azure или GCE.

>Я как администратор приложения, хочу иметь возможность разворачивать нужную инфраструктуру (базы данных, s3, dns и балансировщики) с помощью одного и того же инструмента.

>Я как сотрудник СИБ, хочу иметь возможность программно (и опять же - единообразно) получить информацию обо всех объектах публичных облаков и их настройках.

>Я как сотрудник СИБ, хочу иметь можность настраивать политики, ограничивающие использование отдельных функций, полей, объектов публичных облаков.

## Out of scope
На текущем этапе (осень 2021г) мы не знаем, какая модель организации взаимодействия между облаками подойдёт. Например, мы не знаем:
  * насколько обособлены разные БЮ - нужен ли будет каждому отдельный kubernetes cluster?
  * насколько обособлены команды внутри БЮ - нужен ли будет каждому отдельный kubernetes cluster или достаточно разделения по БЮ?
  * какая схема удобна/необходима для биллинга? одинакова ли она для всех облачных провайдеров?
  * как кластеры между командами/БЮ будут связаны (если будут) - через балансеры, облачные маршрутизаторы?
И это только вопросы, которые мы смогли увидеть и сформулировать, но точно будут другие. Наша задача попробовать выбрать инструменты, которые позволят реализовать любые (ну или хотя бы большинство) потенциальных сценариев.

## Kubernetes all the things
Исходя из:
  * описанных выше user story
  * факта, что 90% сервисов будут использовать kubernetes
мы рассматриваем вариант управления всей инфраструктурой публичных облаков через kubernetes API. Т.е. управлять и выкладкой самого приложения и инфраструктурой для него через kube api и kubectl.

На уровне идеи - понятно. А на практике есть множество вопросов, здесь мы смотрим на то, как организовать **workflow** на примере таких историй:
>Создать/настроить/обновить k8s кластер в Azure.

>Развернуть своё приложение в существующем кластере. Это включает в себя: развёртывание базы данных, настройка балансировщика и внешний IP адрес.
>После развёртывания я хочу управлять приложением и его инфраструктурой, получать и понимать статус.

## Single point of access
Идея такая:
>Я подключаюсь к единой инсталляции kube-apiserver'а. Создаю там AKSCluster. Затем создаю kubernetes объекты (моего приложения), а машинерия инфраструктуры синхронизирует их с api-server AKS. Пишет spec, читает status.

В такой схеме на первый взгляд подкупает её простота для пользователя: не нужно аутентифицироваться в разных облаках и поддерживать разные idenitity, знать много gory подробностей про устройство различных инсталляций.

![single point flow](assets/single-seq.svg "Sequence")

На практике же возникают сложности (вытекают из плюсов схемы):
  * меняется работа со штатными объектами kubernetes
    * их нужно "перекладывать" в другой кластер
    * потенциально нужно перекладывать поды/их статусы - это дорого
    * node'ы никак не будут представлены в single point кластере
  * смешивать cluster scoped и namespace scoped ресурсы нетривиально в одном кластере

## Provision and branch
Можно посмотреть на вариант, когда мы моделируем кластер и работу с ним как с большим хостом:
  * `ssh <hostname>` -> `kubectl use-context <cluster-name>`  - выбираем нужный кластер
  * `dpkg --list && systemctl list-units` -> `kubectl api-resources` - смотрим доступные нам программы
  * `ps -ef` -> `kubectl get deployments` - смотрим запущенные программы
  * `systemctl start <service>` -> `kubectl apply -f .` - запускаем новые

Такой подход достаточно интуитивный и пользователям будет относительно просто это объяснить, а затем они сами смогут ориентироваться. В таком подходе предлагается:
  * иметь bootstrap/backbone кластер kubernetes (например, в YC), к которому у всех сотрудников есть доступ.
  * внутри кластера есть namespace'ы, созданные per business unit (abc service?)
  * внутри namespace'ов пользователи могут запускать только одно приложение - managed kubernetes в стороннем облаке.
  * после этого пользователь настраивает kubectl для использования вновь созданной "машины"
  * внутри этой машины пользователь может:
    * создавать объекты конкретного облака - S3, Redis, Postgre и т.д.
    * запускать приложение, используя "штатные" объекты - Deployment'ы и Pod'ы.

![federated flow](assets/federated-seq.svg "Sequence")

Самый тонкий момент в схеме - переключение между инсталляциями. В managed k8s'ах используется аутентификация средствами IAM'ов конкретного облака. Значит с каждым нужно настроить:
  * [Active Directory Federation Service](https://docs.microsoft.com/en-us/windows-server/identity/ad-fs/deployment/how-to-connect-fed-azure-adfs)
  * раздачу "базовых" прав пользователям

Это выполняется примерно один раз на облачного провайдера.

В итоге:
  * `+` (относительно) понятная модель
  * `+` нет единой точки отказа - если недоступен boostrap кластер, то работа не остановится
  * `-` нужна аутентификация в каждом провайдере
  * `-` неплоская схема, потенциально усложняет некоторые сценарии (например, СИБ) - но они остаются доступными
  * `?` у пользователей остаётся возможность прямого доступа (как минимум на чтение) в нативные панели управления облаками - для анализа, мониторинга и отладки
