import os

from doit.tools import create_folder


GENISYS_URL = "https://proxy.sandbox.yandex-team.ru/119632560"
GENISYS_SHA256 = "895f6a8f7ef46c81c3ad5a9a016c3ee84cbe05eefe4445a243b99eaa3c386ab2"

MONGODB_URL = "http://fastdl.mongodb.org/linux/mongodb-linux-x86_64-ubuntu1204-3.0.11.tgz"
MONGODB_SHA256 = "a64daa8445d280c2c48940a8c42aaa7af7e696befcefb2fac181cd0c74fb0c29"

REDIS_URL = "http://download.redis.io/releases/redis-3.0.7.tar.gz"
REDIS_SHA256 = "b2a791c4ea3bb7268795c45c6321ea5abcc24457178373e6a6e3be6372737f23"

BUILD_PATH = 'build'
LIB_PATH = os.path.join(BUILD_PATH, 'lib')
PYSITE_PATH = os.path.join(LIB_PATH, 'python3.4', 'site-packages')

DL_PATH = '.downloads'

GENISYS_PATH = os.path.join(DL_PATH, 'genisys.tgz')

MONGODB_PATH = os.path.join(DL_PATH, 'mongodb.tgz')

REDIS_PATH = os.path.join(DL_PATH, 'redis.tar.gz')

LACMUS2_BUNDLE = 'dist/lacmus2.tgz'

BUNDLE_PYTHON_LIBS = [
    'redis==2.10.5',
    # this is only needed by skynet.api
    'py==1.4.31',
]


def task_get_genisys():
    return {
        'actions': [
            (create_folder, [BUILD_PATH]),
            (create_folder, [DL_PATH]),
            'wget -O "%s" --no-check-certificate "%s" '
            '--progress=dot:mega' % (GENISYS_PATH, GENISYS_URL)
        ],
        'targets': [GENISYS_PATH],
        'uptodate': ['sha256sum %s | grep %s' % (GENISYS_PATH, GENISYS_SHA256)]
    }


def task_get_redis():
    return {
        'actions': [
            (create_folder, [BUILD_PATH]),
            (create_folder, [DL_PATH]),
            'wget -O "%s" --no-check-certificate "%s" '
            '--progress=dot:mega' % (REDIS_PATH, REDIS_URL),
        ],
        'targets': [REDIS_PATH],
        'uptodate': ['sha256sum %s | grep %s' % (REDIS_PATH, REDIS_SHA256)]
    }


def task_build_redis():
    return {
        'actions': [
            'rm -rf build/redis && mkdir -p build/redis',
            'tar --strip-components=1 -xzf "%s" -C build/redis' % (REDIS_PATH, ),
            'cd build/redis && make',
        ],
        'targets': ['%s/build/redis/bin/redis-server' % (BUILD_PATH, )],
        'file_dep': [REDIS_PATH],
    }


def task_get_mongodb():
    return {
        'actions': [
            (create_folder, [BUILD_PATH]),
            (create_folder, [DL_PATH]),
            'wget -O "%s" --no-check-certificate "%s" '
            '--progress=dot:mega' % (MONGODB_PATH, MONGODB_URL),
        ],
        'targets': [MONGODB_PATH],
        'uptodate': ['sha256sum %s | grep %s' % (MONGODB_PATH, MONGODB_SHA256)]
    }


def task_build_mongodb():
    return {
        'actions': [
            'rm -rf build/mongodb && mkdir -p build/mongodb',
            'tar --strip-components=1 -xzf "%s" -C build/mongodb' % (MONGODB_PATH, ),
        ],
        'targets': ['%s/build/mongodb/bin/mongod' % (BUILD_PATH, )],
        'file_dep': [MONGODB_PATH],
    }


def task_deb_mongodb():
    return {
        'actions': [
            'echo $PATH',
            'rm -rf "%s/deb-mongodb"; mkdir -p "%s/deb-mongodb/bin"' % (BUILD_PATH, BUILD_PATH),
            'cp "%s/mongodb/bin/mongod" "%s/deb-mongodb/bin"' % (BUILD_PATH, BUILD_PATH),
            'cp -r share/mongo/packaging/debian "%s/deb-mongodb"' % (BUILD_PATH, ),
            'cp -r share/mongo/init "%s/deb-mongodb"' % (BUILD_PATH, ),
            'cp -r share/mongo/logrotate.d "%s/deb-mongodb"' % (BUILD_PATH, ),
            'cd "%s/deb-mongodb" && debuild --no-lintian --no-tgz-check && debrelease -t search' % (BUILD_PATH, ),
        ],
        'clean': [
            'rm -rf "%s/deb-mongodb"' % (BUILD_PATH, ),
        ],
        'task_dep': ['build_mongodb']
    }


def task_deb_redis():
    return {
        'actions': [
            'echo $PATH',
            'rm -rf "%s/deb-redis"; mkdir -p "%s/deb-redis/bin"' % (BUILD_PATH, BUILD_PATH),
            'cp "%s/redis/src/redis-server" "%s/deb-redis/bin"' % (BUILD_PATH, BUILD_PATH),
            'cp "%s/redis/src/redis-cli" "%s/deb-redis/bin"' % (BUILD_PATH, BUILD_PATH),
            'ln -s redis-server "%s/deb-redis/bin/redis-sentinel"' % (BUILD_PATH, ),
            'cp -r share/redis/packaging/debian "%s/deb-redis"' % (BUILD_PATH, ),
            'cp -r share/redis/init "%s/deb-redis"' % (BUILD_PATH, ),
            'cp -r share/redis/logrotate.d "%s/deb-redis"' % (BUILD_PATH, ),
            'cd "%s/deb-redis" && debuild --no-lintian --no-tgz-check && debrelease -t search' % (BUILD_PATH, ),
        ],
        'clean': [
            'rm -rf "%s/deb-redis"' % (BUILD_PATH, ),
        ],
        'task_dep': ['build_redis']
    }


def task_genisys():
    return {
        'actions': [
            'mkdir -p "%s"' % (BUILD_PATH, ),
            'tar -C "%s" -xzf "%s" bin lib' % (BUILD_PATH, GENISYS_PATH),
        ],
        'clean': [
            'rm -rf "%s"' % (BUILD_PATH, )
        ],
        'file_dep': [GENISYS_PATH],
        'uptodate': ['%s/bin/python -V' % (BUILD_PATH, )]
    }


def task_build_python_library():
    for dep in BUNDLE_PYTHON_LIBS:
        name, ver = dep.split('==')

        yield {
            'name': name,
            'actions': [
                './build/bin/pip '
                '   --disable-pip-version-check install '
                '   --trusted-host pypi.yandex-team.ru '
                '   -i http://pypi.yandex-team.ru/simple '
                '   --no-deps "%s"' % (dep, ),
            ],
            'task_dep': ['genisys'],
            'uptodate': ['./build/bin/pip --disable-pip-version-check freeze | grep "%s"' % (dep, )],
        }


def task_build():
    return {
        'actions': [
            'rm -rf "%s/lacmus2"' % (PYSITE_PATH, ),
            'rm -f "%s/bin/lacmus2-run-toiler.py"' % (BUILD_PATH, ),
            'rm -f "%s/bin/lacmus2-run-wsgi.py"' % (BUILD_PATH, ),
            'cp -r lacmus2 "%s/"' % (PYSITE_PATH, ),
            'cp ctl.py "%s"' % (BUILD_PATH, ),
            'cp lacmus.scsd "%s"' % (BUILD_PATH, ),
            'cp ./scripts/start_server.py "%s/bin/"' % (BUILD_PATH, ),
            'cp ./scripts/ping_server.py "%s/bin/"' % (BUILD_PATH, ),
            'cp ./scripts/stop_server.py "%s/bin/"' % (BUILD_PATH, ),
            'cp ./scripts/run-toiler "%s/bin/lacmus2-run-toiler.py"' % (BUILD_PATH, ),
            'cp ./scripts/run-wsgi "%s/bin/lacmus2-run-wsgi.py"' % (BUILD_PATH, ),
            '%s/bin/python -m compileall "%s"' % (BUILD_PATH, PYSITE_PATH),
            'find -D stat %s/bin -type l -delete' % (BUILD_PATH, )
        ],
        'task_dep': [
            'genisys',
            'build_python_library',
        ]
    }


def task_bundle():
    return {
        'actions': [
            'mkdir -p dist',
            'tar -C build -czf "%s" bin lib ctl.py lacmus.scsd' % (LACMUS2_BUNDLE, )
        ],
        'targets': [LACMUS2_BUNDLE],
        'clean': ['rm -rf dist'],
        'task_dep': ['build']
    }
