from genisys.toiler import base

from lacmus2.toiler import config


class ChartVtypeProcessor(object):
    def __init__(self, redis_storage, historical_storage):
        self.redis = redis_storage
        self.historical = historical_storage

    def get_result_ttl(self, record):
        if self.redis.is_chart_viewed(record['key']):
            return config.CHART_VIEWED_RESULT_TTL
        else:
            return config.CHART_RESULT_TTL

    def __call__(self, database, record, forced):
        svtype = record['source']['selector_vtype']
        skey = record['source']['selector_key']
        if svtype and skey:
            base.update_volatiles_atime(database, vtype=svtype, keys=[skey])
            yield "updated %s %r atime" % (svtype, skey)
        chart = self.redis.get_chart(
            svtype, skey,
            record['source']['signal'],
            record['source']['filters']
        )
        yield "chart results: %r" % (chart, )
        return chart, record['meta']

    def postprocess_value(self, record, value):
        if not value:
            return
        self.historical.write_point(record['key'], value)
