MONGODB_URI = ['mongodb://127.0.0.1/']

MONGODB_DB_NAME = 'lacmus2'

# in bytes
HISTORICAL_SIZE = 20 * (1 << 20)
HISTORICAL_DB_NAME = 'lacmus2historical'
HISTORICAL_MAX_POINTS = 2880

STATSD_HOST = '127.0.0.1'

STATSD_PORT = 8125

REDIS = dict(
    USE_SENTINEL=False,
    HOST='127.0.0.1',
    PORT=6379,
    SOCKET_TIMEOUT=10,
    RETRY_ON_TIMEOUT=True,
    DBNUM=0,
)
# or for using sentinel:
#
# REDIS = dict(
#     USE_SENTINEL=True,
#     SENTINEL_SERVICE_NAME='lacmus2',
#     SENTINELS=[(sentinel1_host, sentinel1_port), ...],
#     SOCKET_TIMEOUT=10,
#     RETRY_ON_TIMEOUT=True,
#     DBNUM=0,
# )

PROCESS_ONLY_VTYPES = None

EAGER = False

FORCED_UPDATE_FROM_MTIME = None

# postpone time = min(MAX_POSTPONE_TIME, MIN_POSTPONE_TIME + (POSTPONE_BACKOFF_BASE ** postpone_count) - 1)
POSTPONE_BACKOFF_BASE = 1.3
MAX_POSTPONE_TIME = 20 * 60
MIN_POSTPONE_TIME = 5

TOILER_SLEEP_ON_NOTHING_TO_DO = 5


# specific vtype-processors config

# selector
SELECTOR_SKY_LIST = ('sky', 'list')
SELECTOR_SKY_LIST_TIMEOUT = 10 * 60
SELECTOR_RESULT_TTL = 300

# genisys_selector
GENISYS_API_URI = 'http://genisys.yandex-team.ru'

# chart
CHART_RESULT_TTL = 30
CHART_VIEWED_RESULT_TTL = 3

# dashboard
DASHBOARD_RESULT_TTL = 3600


import os
if 'LACMUS2_TOILER_CONFIG' in os.environ:
    filename = os.environ['LACMUS2_TOILER_CONFIG']
    try:
        with open(filename) as config_file:
            exec(compile(config_file.read(), filename, 'exec'), globals())
    except BaseException as ex:
        import sys
        import os

        sys.stderr.write('Error: unable to load config from %s: %s\n' %
                         (filename, ex))
        sys.stderr.flush()
        os._exit(1)

    del os.environ['LACMUS2_TOILER_CONFIG']
