from genisys.toiler import base
from lacmus2.toiler import config


def dashboard_vtype_processor(database, record, forced):
    yield "updating dashboard's itself atime"
    base.update_volatiles_atime(database, 'dashboard', [record['key']])
    yield "updating %d charts atimes" % \
          (len(record['source']['charts']), )
    base.update_volatiles_atime(
        database, 'chart', [chart['key']
                            for chart in record['source']['charts']]
    )
    return {}, record['meta']

dashboard_vtype_processor.RESULT_TTL = config.DASHBOARD_RESULT_TTL
