import requests
import msgpack

from lacmus2.toiler import config
from lacmus2.toiler.selector import SelectorVtypeProcessor


class GenisysSelectorVtypeProcessor(SelectorVtypeProcessor):
    def __call__(self, database, record, forced):
        uri = "%s/v2/hosts-by-path-and-rulename" % (config.GENISYS_API_URI, )
        yield "fetching hosts from genisys api %r using path %r and " \
              "rule name %r" % \
              (uri, record['source']['path'], record['source']['rule'])
        resp = requests.get(uri, {'path': record['source']['path'],
                                  'rulename': record['source']['rule'],
                                  'fmt': 'msgpack'})
        resp.raise_for_status()
        hosts = msgpack.loads(resp.content, encoding='utf8')['hosts']
        if hosts is None:
            yield "got None, maybe genisys doesn't know that section/rule"
            return None, record['meta']
        yield "got %d hosts" % (len(hosts), )
        return sorted(hosts), record['meta']
