import pymongo

from genisys.toiler import base, stats
import lacmus2.redis
from lacmus2.historical import Lacmus2HistoricalStorage
from lacmus2.toiler import selector, chart, genisys_selector, dashboard
from lacmus2.toiler import config


def get_registry():
    redis_storage = lacmus2.redis.Lacmus2RedisStorage(config.REDIS)
    mongo_client = pymongo.MongoClient(config.MONGODB_URI)
    historical_storage = Lacmus2HistoricalStorage(mongo_client, vars(config))
    return {
        'selector': selector.SelectorVtypeProcessor(redis_storage),
        'chart': chart.ChartVtypeProcessor(redis_storage, historical_storage),
        'genisys_selector': genisys_selector.GenisysSelectorVtypeProcessor(redis_storage),
        'dashboard': dashboard.dashboard_vtype_processor
    }


def make_toiler():
    mongo_client = pymongo.MongoClient(config.MONGODB_URI)
    db = mongo_client[config.MONGODB_DB_NAME]

    reg = get_registry()
    if config.PROCESS_ONLY_VTYPES:
        reg = {key: reg[key] for key in config.PROCESS_ONLY_VTYPES}

    toiler_stats = stats.ToilerStats(config.STATSD_HOST, config.STATSD_PORT)

    toiler = base.Toiler(
        db, reg, is_eager=config.EAGER, stats=toiler_stats,
        forced_update_from_mtime=config.FORCED_UPDATE_FROM_MTIME
    )
    return toiler
