from genisys.toiler.selector import selector_vtype_processor as genisys_proc

from lacmus2.toiler import config


class SelectorVtypeProcessor(object):
    RESULT_TTL = config.SELECTOR_RESULT_TTL

    def __init__(self, redis_storage):
        self.redis = redis_storage

    def __call__(self, database, record, forced):
        return genisys_proc(database, record, forced)

    def postprocess_value(self, record, value):
        self.redis.save_selector_hosts(
            record['vtype'], record['key'], value or []
        )
